#include <bits/stdc++.h>

using namespace std;

#define mp make_pair
#define pb push_back
#define all(x) (x).begin(),(x).end()
#define in(x) int x=nxt()

using namespace std;

inline int nxt() {
    int n;
    scanf("%d", &n);
    return n;
}

typedef pair <int, int> PII;
typedef long long ll;
typedef unsigned long long ull;
typedef int itn;
typedef long double ld;

struct edge {
    int from;
    int to;
    int u;
    int f;
};

const int M = 10000;
const int N = 500;
edge e[M + M];
vector <int> g[N];
int q[N];

int sz = 0;

void addEdge (int a, int b, int c) {
    edge A = edge{a, b, c, 0};
    edge B = edge{b, a, 0, 0};
    g[a].pb(sz);
    e[sz++] = A;
    g[b].pb(sz);
    e[sz++] = B;
}

int p[N];
char used[N];
int n, m;

bool bfs(int s, int t) {
    memset(used, 0, n * sizeof(char));
    int q1 = 0, q2 = 0;
    q[q1++] = s;
    used[s] = 1;
    while (q1 != q2) {
        int v = q[q2++];
        if (v == t) {
            return true;
        }
        for (int E : g[v]) {
            edge & ee = e[E];
            if (ee.f != ee.u && !used[ee.to]) {
                q[q1++] = ee.to;
                p[ee.to] = E;
                used[ee.to] = 1;
            }
        }
    }
    return false;
}

void relax(int s, int t) {
    for (int cur = t; cur != s; cur = e[p[cur]].from) {
        //cerr << cur << " ";
        int E = p[cur];
        e[E].f++;
        e[E ^ 1].f--;
    }
}

bool bfs2(int s, int t) {
    memset(used, 0, n * sizeof(char));
    int q1 = 0, q2 = 0;
    q[q1++] = s;
    used[s] = 1;
    while (q1 != q2) {
        int v = q[q2++];
        if (v == t) {
            return true;
        }
        for (int E : g[v]) {
            edge & ee = e[E];
            if (ee.u > 0 && ee.f > 0 && !used[ee.to]) {
                q[q1++] = ee.to;
                p[ee.to] = E;
                used[ee.to] = 1;
            }
        }
    }
    return false;
}

vector <vector <int> > ans;

void relax2(int s, int t) {
    vector <int> q;
    for (int cur = t; cur != s; cur = e[p[cur]].from) {
        if (cur != t) q.push_back(cur);
        int E = p[cur];
        e[E].f--;
    }
    reverse(all(q));
    ans.push_back(q);
}

int maxFlow(int s, int t) {
    int flow = 0;
    while (bfs(s, t)) {
        ++flow;
        relax(s, t);
    }
    return flow;
}

void solve() {
    in(nn);
    int d1[nn], d2[nn];
    memset(d1, 0, sizeof(d1));
    memset(d2, 0, sizeof(d2));
    vector <pair <int, int> > E;
    for (int i = 0; i < nn; ++i) {
        in(k);
        while (k--) {
            in(v);
            --v;
            d1[i]++;
            d2[v]++;
            E.push_back(mp(i, v));
        }
    }

//    for (int i = 0; i < nn; ++i) {
//        cout << d1[i] << " " << d2[i] << "\n";
//    }

    n = nn + 2 + 2;

    int s = nn;
    int t = nn + 1;
    int S = nn + 2;
    int T = nn + 3;


    for (auto u : E) {
        addEdge(u.first, u.second, 1e9);
    }
    for (auto u : E) {
        addEdge(S, u.second, 1);
        addEdge(u.first, T, 1);
    }

    for (int i = 0; i < nn; ++i) {
        if (d1[i] == 0) {
            addEdge(i, t, 1e9);
        }
        if (d2[i] == 0) {
            addEdge(s, i, 1e8);
        }
    }

    addEdge(t, s, 0);
    int l = 0, r = E.size();
    while (l < r) {
        int m = (l + r) / 2;
        for (int i = 0; i < sz; ++i) {
            e[i].f = 0;
        }
        e[sz - 2].u = m;
        int flow = maxFlow(S, T);
        if (flow < (int)E.size()) {
            l = m + 1;
        } else {
            r = m;
        }
    }
    for (int i = 0; i < sz; ++i) {
        e[i].f = 0;
    }
    e[sz - 2].u = l;
    maxFlow(S, T);

    for (int i = 0; i < (int)E.size(); ++i) {
        e[i + i].f++;
    }

    while (bfs2(s, t)) {
        relax2(s, t);
    }

    cout << ans.size() << "\n";
    for (auto & v : ans) {
        for (int y : v) {
            cout << y + 1 << " ";
        }
        cout << "\n";
    }
}

int main()
{
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
#endif // LOCAL
    solve();
    return 0;
}
